<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslResourceDirectory" select="cif:xslResourceDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                
                <title lang="en">Geometry Point Report</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Project Coordinate Table Report</h2>
                                <p lang="en">
                                    Report Created:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Time:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                          <xsl:for-each select="GeometryProject">

                            <hr/>

                            <xsl:for-each select="GeometryPoint">
                            <table class="margin" border="1" cellpadding="4" cellspacing="0">
                                <thead style="display:table-header-group">
				<tr>
                                    <th align="center" colspan="5">PROJECT COORDINATE TABLE</th>
                                  </tr>

                                  <tr>
                                    <th align="center" rowspan="2">Point No.</th>
                                    <th align="center" colspan="2">Project Coordinates</th>
                                    <th align="center" rowspan="2">Elevation (Ft.)<br/> (NAVD88)</th>
                                    <th align="center" rowspan="2">Description</th>
                                  </tr>

                                  <tr>
                                    <th align="center">Northing (Ft.)</th>
                                    <th align="center">Easting (Ft.)</th>
                                  </tr>
                                </thead>
                                <tbody>
                                  <xsl:for-each select="GeometryPointProperties">
                                    <tr>
                                      <td align="center">
                                        <xsl:value-of select="@PointName"/>
                                      </td>
                                      <td align="center">
                                        <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                      </td>
                                      <td align="center">
                                        <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                                      </td>

                                       <td align="center">
                                        <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                                      </td>
                                      <td align="center">
                                        <xsl:value-of select="@PointDescription"/>
                                      </td>

                                    </tr>
                                  </xsl:for-each>
                                </tbody>
                              </table>
                            </xsl:for-each>
                          </xsl:for-each>

                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Notes</h4>
            <p class="normal1" lang="en">
                You must create station offset points for this report by selecting <em>
                    Tools &gt; XML
                    Reports &gt; Station Offset
                </em>.
            </p>
            <p class="normal1" lang="en">
                You must include at least one horizontal alignment or one feature on the <em>General</em>
                leaf in the <em>From</em> fields.
            </p>
            <p class="normal1" lang="en">
                You must also include at least one horizontal alignment on the <em>
                    Horizontal Alignments
                </em> leaf or one feature on the <em> Features</em> leaf.
            </p>
            <p class="normal1" lang="en">
                You must choose at least one option on the <em>Include</em> leaf (<em>
                    Horizontal On-
                    Alignment Points, Horizontal Event Points, Vertical On-Alignment Points, Vertical Event
                    Points
                </em> or <em>Interval</em>.)
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2013 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
<!-- Compiled by Chris Ferree - EnvisionCAD January 31, 2022 -->